package gov.va.med.mhv.sm.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;
import gov.va.med.mhv.sm.admin.model.AbstractBaseEntity;
import gov.va.med.mhv.sm.admin.enums.RelationTypeEnum;

@Entity
@Table(name = "TRIAGE_RELATION")
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true) 
public class TriageRelation extends AbstractBaseEntity{

	private static final long serialVersionUID = 713904806128639016L;
	
	@Id
	@Column(name = "RELATION_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Column(name = "RELATION_NAME")
	private String name;
	
	@Column(name = "RELATION_TYPE")
	@Enumerated(EnumType.ORDINAL)
	private RelationTypeEnum relationType;

	@Column(name = "RELATION_TYPE", insertable = false, updatable = false)
	private Long relationTypeId;
	
	@Column(name = "VISTA_DIV")
	private String stationNumber;
	
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="TRIAGE_GROUP_ID")
	private TriageGroup triageGroup;
	
	@Column(name = "TRIAGE_GROUP_ID", insertable = false, updatable = false)
	private Long triageGroupId;
	
	@Column(name = "VISTA_IEN")
	private String vistaIen;
	
	public TriageRelation(){
		this.active=true;
		this.createdDate=new Date();
		this.modifiedDate=new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public RelationTypeEnum getRelationType() {
		return relationType;
	}

	public void setRelationType(RelationTypeEnum relationType) {
		this.relationType = relationType;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public TriageGroup getTriageGroup() {
		return triageGroup;
	}

	public void setTriageGroup(TriageGroup triageGroup) {
		this.triageGroup = triageGroup;
	}

	public Long getTriageGroupId() {
		return triageGroupId;
	}

	public void setTriageGroupId(Long triageGroupId) {
		this.triageGroupId = triageGroupId;
	}

	public String getVistaIen() {
		return vistaIen;
	}

	public void setVistaIen(String vistaIen) {
		this.vistaIen = vistaIen;
	}
	
	
}
